IF  EXISTS (SELECT * FROM sys.triggers WHERE object_id = OBJECT_ID(N'[dbo].[TRG_EST_PROD_REQ_TRANSF_LIB_ITENS_ENT_EST_PROD_IMP_PENDENTE]'))
	DROP TRIGGER [dbo].[TRG_EST_PROD_REQ_TRANSF_LIB_ITENS_ENT_EST_PROD_IMP_PENDENTE]
GO
--Versao 2700
CREATE TRIGGER [dbo].[TRG_EST_PROD_REQ_TRANSF_LIB_ITENS_ENT_EST_PROD_IMP_PENDENTE] ON [dbo].[EST_PROD_REQ_TRANSF_LIB_ITENS_ENT_EST_PROD_IMP] 
FOR INSERT,UPDATE
AS
UPDATE
	p
SET 
	p.DT_PROC=imp.DT_CAD,
	p.DT_CAD=GETDATE()
FROM
	EST_PROD_CPL_CUSTO_MEDIO_PROCESSAMENTO_PENDENTE p INNER JOIN EST_PROD_IMP imp ON
	p.CD_EMP = imp.CD_EMP AND
	p.CD_FILIAL = imp.CD_FILIAL AND
	p.CD_PROD = imp.CD_PROD
	INNER JOIN INSERTED i ON   
	imp.CD_EMP = i.CD_EMP AND   
	imp.CD_FILIAL = i.CD_FILIAL_DEST AND   
	imp.CD_IMP = i.CD_IMP AND   
	imp.CD_PROD = i.CD_PROD  
WHERE
	p.DT_PROC > imp.DT_CAD;

INSERT INTO EST_PROD_CPL_CUSTO_MEDIO_PROCESSAMENTO_PENDENTE
	(CD_EMP,
	CD_FILIAL,
	CD_PROD,
	DT_PROC,
	DT_CAD,
	DT_PROC_ATUAL)
SELECT DISTINCT 
	i.CD_EMP,
	i.CD_FILIAL_DEST,
	i.CD_PROD,
	MIN(imp.DT_CAD),
	GETDATE(),
	NULL
FROM
	EST_PROD_IMP imp INNER JOIN INSERTED i ON   
	imp.CD_EMP = i.CD_EMP AND   
	imp.CD_FILIAL = i.CD_FILIAL_DEST AND   
	imp.CD_IMP = i.CD_IMP AND   
	imp.CD_PROD = i.CD_PROD  
	LEFT OUTER JOIN EST_PROD_CPL_CUSTO_MEDIO_PROCESSAMENTO_PENDENTE p ON
	p.CD_EMP = imp.CD_EMP AND
	p.CD_FILIAL = imp.CD_FILIAL AND
	p.CD_PROD = imp.CD_PROD
WHERE
	p.CD_PROD IS NULL
GROUP BY
	i.CD_EMP,
	i.CD_FILIAL_DEST,
	i.CD_PROD;

--Deletando ultimo processamento de custo medio
DELETE
	p
FROM
	EST_PROD_CPL_CUSTO_MEDIO_DT_PROC_ULTIMO p INNER JOIN INSERTED i ON
	p.CD_EMP = i.CD_EMP AND
	p.CD_FILIAL = i.CD_FILIAL_DEST AND
	p.CD_PROD = i.CD_PROD;

